/**
 * URM – Instructions
 *
 * This file provides an overview of the purpose and functionality of the User Role Membership snippet.
 * Includes detailed setup guidelines, examples of integration with third-party plugins (e.g. Gamipress),
 * and philosophical notes on the author's approach to user roles and gamification.
 *
 * Author: Black & Copilot
 */

// 🆘 URM - Instructions

function render_ur_help_tab() {
    echo '<div style="margin-top: 0px; background: #fff; border: 1px solid #ccc; border-radius: 0px; box-shadow: 0 1px 3px rgba(0,0,0,0.05); overflow: hidden;">';
	
	// 👑 Frame header
    echo '<div style="background: #f7f9fa; padding: 10px 16px; border-bottom: 1px solid #ccc; font-weight: bold; font-size: 16px;">📋 Instructions</div>';
	
	// 📦 Internal content
    echo '<div style="padding: 0px 20px 20px 20px;">';
	
	echo '<p style="color: black; font-size: 16px"><strong>📘 Introduction</strong></p>';
    echo '<p style="color: gray;  font-size: 16px">I created this snippet because I couldn`t find any plugin that would provide me exactly what I need without unnecessary features and options. No plugin provides the option to assign a role with a time duration by spending points that the user has earned through their activity on the site. Also, this snippet does not define role capabilities directly but relies on already existing plugins. One such plugin is the excellent and free plugin "User Role Editor". I personally use the "PeepSo Ultimate Bundle" which includes the "User Restrictions" add-on for configuring user role permissions. This snippet does not contain a payment gateway since it relies on gamification plugins on the other side that have their own add-ons for controlling the balance of user points and the ability to deduct points based on the assignment of user roles. I personally use the "Gamipress" plugin with its add-ons.</p>';
	
	echo '<p style="color: black; font-size: 16px"><strong>📘 What does this snippet do?</strong></p>';
    echo '<p style="color: gray;  font-size: 16px">The Snippet User Role Membership is used for creating or deleting privileged roles with the possibility of configuring the duration of the role. Time-based roles are created by entering the role name in the field "Enter role name" and by clicking the "Add" button you create a new role. For each duration, it is necessary to create a special role. For different durations, you can use the same role name but add a suffix depending on the time duration. For example: "Basic_1_m" for the role to which you will assign 1 month duration, "Basic_3_m" for 3 months, etc. Between the role name and the continuation, an underscore is mandatory, and the role must be a single word because some plugins do not understand spaces in the role name. Basically, you can use any role name of your choice as long as you make sure to assign the right duration to the right role. The quantity and type of points here are to inform the future created shortcode how many and which points you will deduct for each role, and the shortcode will display this along with other information on the frontend of the page. Regardless of which gamification plugin you are using, you will need to customize this part according to your needs in such a way that value="slug" of your point, and "First" is the name you gave it when creating points in the gamification plugin. In my example, there are three types of points, but you can add or subtract as many types of points as you want.</p>';
	$code_snippet = '<!-- Type of points -->
        <div style="flex: 1 1 100px;">
          <label for="points_type" style="font-weight: bold;">Type of points:</label><br>
          <select name="points_type" id="points_type" style="width: 100%;" required>
            <option value="first">First</option>
            <option value="second">Second</option>
            <option value="third">Third</option>
          </select>
        </div>';
    echo '<p style="color: gray; font-size: 16px;"><strong>Regardless of which gamification plugin you use, you will need to customize it:</strong></p>';
    echo '<pre style="background: #f5f5f5; padding: 10px; border: 1px solid #ccc; border-radius: 6px; color: black; font-size: 14px;"><code>' . htmlspecialchars($code_snippet) . '</code></pre>';
    echo '<p style="color: gray;  font-size: 16px">Now in the window "Add role duration" enter the name of the newly created role, select the duration of the role, select quantity and type of points. When you correctly fill in all fields and click the button "Create short code in the table", you will receive a short code that will, when you set it on the frontend, show, for example: "Role: Basic 1 month, Duration: 1 month, Price: 100 Points" and show the button "Change Role". You can name your frontend page where you will place the short codes <b>[message_role_change]</b>, <b>[process_log]</b>, and <b>[shortcode_role...]</b> whatever you want, but the page slug must be "https://example.com/<strong>membership</strong>" or code modification will be required if you want to change it. I suggest that you place the shortcodes <b>[message_role_change]</b> and <b>[process_log]</b> at the top of the page, either next to each other or one below the other, so they are always visible to the user. You should design how each individual card will look on your page for users, and attach the corresponding shortcode <b>[shortcode_role...]</b> that should be consistent with the respective card.</p>';
	
	echo '<p style="color: black; font-size: 16px"><strong>📘 Other options</strong></p>';
    echo '<p style="color: gray;  font-size: 16px"> When you first try to create shortcodes <b>[shortcode_role...]</b>, you might make a mistake, but don`t worry, there is a "Delete" button at the end of each row so you can remove the incorrect row and fix the issue. If you, for some reason, want to reset the entire table, you can do so with the "Reset the table" button, and a backup of the table will be automatically created, so if you want to restore it, you can always do that with the "Restore" button. You can also download your records from the table to your PC by clicking on "Download". If you think you no longer need the backup, it can be easily deleted by clicking on "Delete" button.<br><br>User Role Membership monitors the process of assigning or revoking roles to individual users, as well as all other processes that take place in the background. If you click on the "Process monitoring" tab, you will see a detailed list of processes occurring while using this snippet, organized by time and date. You can export the processes in CSV format for analysis or for whatever you need by clicking the "Export CSV" button. You can also clear the log at any time by clicking the "Clear records" button. If the default entry view is too short, set the number of entries you want and confirm by clicking the "Apply" button, or you can browse through pages.<br><br>Every administrator should know firsthand which user is using which role and for what duration. To control roles, we use the "User list" tab. Here we have the option to search for users by user ID number, username, or email. Below the search bar, there is a table listing all users with privileged roles sorted by the most recently activated roles to the oldest roles. Each user has their ID number, avatar, username, email, start date of the role, expiration date of the role, currently active role, and a "Revoke role" button displayed. Clicking on the username takes us to the user`s front-end profile, and clicking on the email opens the administrator`s email client on their computer so they can contact the specific user if necessary.<br><br>The "Revoke role" button serves multiple purposes. The administrator can use it to revoke a user role if the user has committed an offense and exceeded or abused the powers assigned to their role. It can also be used to suspend a role at the user`s request if the user decides to switch to another role before the expiration of their previous role. The "Revoke role" button always returns the user to the default WordPress role. Due to the verification of whether the user has an active privileged role or not, the user will be prevented from selecting <i>"role on role"</i> which means they will receive a message that they cannot add another role to an already active role until their active role expires, so their only option is to contact the administrator who can revoke their currently active role. Administrators can control the "User list" from the frontend using the shortcode <b>[ur_user_list]</b> which should be placed on a special page that only administrators will have access to. In addition to the option of how many rows of users they want to display, administrators also have the option to export to CSV, as well as a "Clean expired roles" button that will remove users whose privileged role has expired and who have not renewed it.</p>';
	
	echo '<p style="color: black; font-size: 16px"><strong>📘 What does this snippet not do?</strong></p>';
    echo '<p style="color: gray;  font-size: 16px">As I wrote in the introduction, this User Role Membership snippet relies on other plugins when it comes to configuring the permissions of a specific role. With this snippet, the created privileged role for User Role Membership does not differ in any way, except in name, from the default role "Subscriber". You will have to make all the fine adjustments using the already existing plugins. Also, this snippet will not charge for the use of the role. He will only set its duration for the user who selects it. You will need to set the payment of a certain amount of points and the type of points in the plugin you are using for gamification. Before using this snippet, make sure that the gamification plugin you are using can deduct points based on the assigned role.</p>';
	
	echo '<p style="color: black; font-size: 16px"><strong>📘 Personal example</strong></p>';
    echo '<p style="color: gray;  font-size: 16px">Since I am using the "PeepSo Ultimate Bundle" plugin and add-ons for creating a social community, I grant permissions to my created roles through the "User Restrictions" add-on. I have decided on the roles "Basic User", "Advanced User" and "Professional User" which are different in nature, as a higher role level provides more opportunities on the site. For each of those roles, I set the options for selecting time based roles, but with different ways of paying with points.<br><br>For short-term roles, I have enabled payment with points that users of my site can earn through various activities. I have configured 30+ ways for each user to easily earn points every day. In approximately 4 days of active participation, the user can accumulate enough points to unlock "Basic User" role for one month. I have limited the award of points for each action to one per day so that users do not spam the page for points. For longer periods of time, users pay with points awarded as a donation incentiv for donating to the site. Since my site is non-profit, and it does not contain any advertisements, I cover all expenses out of my <i>"own pocket"</i>, so donations are welcome, but users also receive points in countervalue that they can spend on exclusive roles.<br><br>Win-Win arrangement. Users gain an extension of their capabilities and motivation for active participation, while I receive help for server costs and necessary plugins. I am trying to reduce the number of plugins by using snippets, and for the plugins I must have, I am trying to purchase "Life Time" licenses to reduce costs in the future. I also use free plugins if they satisfies my needs. In case I cannot find either a plugin or a snippet that suits me, I have to take matters into my own hands and then a snippet like User Role Membership is created.<br><br>And now about gamification. For gamification, I probably use the best plugin for gamification "Gamipress" and its free and paid add-ons. I created three types of points: Gift point, Referral point, and Donation point. I won`t describe what each point is for because the name itself speaks for it. It is important that some of the points can be exchanged at the exchange, while others, due to their nature, can only be exchanged in one direction. Users are also rewarded when they successfully recommend the site to friends. Yes, all these possibilities are provided by the "Gamipress Bundle" and much more.<br><br>An addition that is important for integration with the User Role Membership snippet is "Restrict Content" and within it the block "Show content if." Let me explain why this add-on. The possibility for "Gamipress" to award or deduct points for certain actions is tremendously vast and there are many integrations through which these capabilities have been expanded. When I created the points that users will pay with, I went to Points Type -> Point name and within each point, I created an automatic deduction of a certain amount of points for granting a specific role. You should do this by selecting "WordPress" using the "Automatic Points Deducts" interface, and then within it, "Get assigned to a role", and then you choose the role that is assigned from the dropdown menu next to it. Below that, enter the number of points you are deducting from the user, and again below that, fill in the label that will be displayed in the user`s earnings and deductions.<br><br>All of this works nicely when it comes to awarding points, but when it comes to deducting points, the situation is not the best because "Deducting points" in the "Gamipress" plugin has one major flaw. If the user`s wallet is empty, "Automatic Points Deducts" will still work and will deduct, for example, -10 points even if the point balance is 0. For this reason, we use the "Restrict Content" add-on -> "Show content if" which will check if the user has enough points to deduct if they want to activate a privileged role. If the user does not have enough points, they will be greeted with a message stating how many points they need to have before the content of the shortcode for changing roles is revealed. If the user has enough points, they will immediately be greeted with the content of our shortcode and a "Change role" button. And when you set all this up correctly following Gamipress documentation, you will have a complete gamification system with concrete application.</p>';
	
    echo '</div>'; // close padding
    echo '</div>'; // close frame
}